<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['prefix' => '/api'],function(){
	Route::get('/lead','Crm\Api\ApiController@leadInfo')->name('lead-api');
	Route::get('/content-order','Crm\Api\ApiController@contentOrder')->name('content-order-api');
	Route::get('/design-order','Crm\Api\ApiController@designOrder')->name('design-order-api');
	Route::get('/subscribers','Crm\Api\ApiController@subscribers')->name('subscribers');

    // Upsale data for edit
    Route::get('/upsale-leads-api','Crm\Api\ApiController@upsaleLeads')->name('upsale-lead-api');
    Route::get('/sub-department-api','Crm\Api\ApiController@getSubDepartment')->name('sub-department-api');
    Route::get('/get-hod-api','Crm\Api\ApiController@getHODs')->name('get-hod-api');
    Route::get('/get-hod-sub-depart-api','Crm\Api\ApiController@getHODSubDepartment')->name('get-hod-sub-depart-api');
    
    // Lead Commenting API
    Route::post('/lead-commenting-post-api', 'Crm\Api\ApiController@commentingPost')->name('lead-commenting-post-api');
    Route::get('/lead-comments-get-api', 'Crm\Api\ApiController@commentGet')->name('lead-commenting-get-api');
    
    // Payment Link
    Route::get('/generator-api', 'Crm\Payment\PaymentController@paymentApi')->name('payment-generator-api');
    
    
    // Payment Link
    Route::get('/card-generator-api', 'Crm\Payment\PaymentController@cardPaymentApi')->name('card-payment-generator-api');
    
    // Production Task Assigned User GET
    Route::get('/get-production-task-assigning-api', 'Crm\Api\ApiController@getTaskAssign')->name('production-task-assigning-api');
    
    // Logo Questionnair Brief Form API
    Route::post('/logo-questionnair-brief', 'Crm\Api\ApiController@logoQuestionnairBrief')->name('logo-questionnair-brief');
    Route::get('/get-logo-questionnair-brief', 'Crm\Api\ApiController@getLogoQuestionnairBrief')->name('get-logo-questionnair-brief');
    
    // For support status
    Route::get('/update-support-status', 'Crm\Api\ApiController@supportStatusApi')->name('update-support-status');
    // For production status
    Route::get('/update-production-status', 'Crm\Api\ApiController@productionStatusApi')->name('update-production-status');
    
    // For edit blog
    Route::get('/get-blog-by-id', 'Crm\Api\ApiController@blogGetById')->name('get_blog_by_id');
    
    // For edit user
    Route::get('/get-user-by-id', 'Crm\Api\ApiController@userGetById')->name('get_user_by_id');

    // Production Task Assign POST
    Route::get('/task-assign-collection-api', 'Crm\Api\ApiController@productionTaskAssigning')->name('task_assign_collection_api');
    
    // Notification Count API
    Route::get('notication-count-api','Crm\Api\ApiController@notificationCount')->name('notification_count_api');
    
    // Notification Details API
    Route::get('notication-details-api','Crm\Api\ApiController@notificationDetails')->name('notification_details_api');
    
    // Notification Click
    Route::get('notication-click-api','Crm\Api\ApiController@notificationClick')->name('notification_click_api');
    
    // Read All Notification Click
    Route::get('notication-read-all-click-api','Crm\Api\ApiController@notificationReadAllClick')->name('notification_read_all_click_api');
    
    // GET Client Card Details
    Route::post('get-card-information-api','Crm\Api\ApiController@getCardDetailsApi')->name('get_card_information_api');
    
    // GET Converge Payment
    Route::get('get-converge-pay-info','Crm\Api\ApiController@convergePayApi')->name('get_converge_pay_info');
    
});

 Route::get('/','Crm\Payment\PaymentController@paymentLinkOutSource')->name('payment-generator-out-source');

// Route::get('/','Auth\AccountController@login')->name('login');
Route::post('/login-account','Auth\AccountController@checklogin')->name('login-account');
Route::get('/logout','Auth\AccountController@logout')->name('logout');
Route::get('/signup','Auth\AccountController@signup')->name('signup');
Route::post('/validate-signup','Auth\AccountController@validate_signup')->name('validate_signup');
Route::get('/forgot-password','Auth\AccountController@forgotPasswordView')->name('forgot-password');

//Route::group(['prefix' => '/'],function(){
//    Route::get('/','Auth\AccountController@login')->name('login');
//});
Route::group(['prefix' => '/crm'],function(){
    Route::get('/index','Crm\HomeController@index')->name('index');
    
    // Roles Routes
    Route::get('/roles', 'Crm\HomeController@roles')->name('roles');
    Route::post('/roles-update','Crm\HomeController@rolesEdit')->name('roles-update');
});

Route::group(['prefix' => '/lead'],function(){
    Route::get('/list','Crm\Leads\LeadsController@index')->name('assignleads');
//    Route::get('/list','Crm\Leads\LeadsController@index')->name('leads');
    Route::get('/records/{type?}/{sdtype?}','Crm\Leads\LeadsController@unassignlead')->name('unassignleads');
    Route::get('/sales-completed','Crm\Leads\LeadsController@completedLeads')->name('leads_completed');
    Route::get('/self','Crm\Leads\LeadsController@userLead')->name('user_lead');
    Route::post('/add','Crm\Leads\LeadsController@addlead')->name('add_leads');
    Route::post('/update','Crm\Leads\LeadsController@updatelead')->name('update_leads');
    Route::post('/upsale-update','Crm\Leads\LeadsController@upsaleLead')->name('upsale_update_leads');
    Route::post('/delete','Crm\Leads\LeadsController@deletelead')->name('delete_leads');
    
    /* For Support Department */
    Route::get('/all-leads/{type}','Crm\Leads\LeadsController@allLeads')->name('all_leads');
    Route::get('/welcome/{type}','Crm\Leads\LeadsController@welcomeLeads')->name('welcome_leads');
    Route::get('/initial-send/{type}','Crm\Leads\LeadsController@initialSendLeads')->name('initial_send_leads');
    Route::get('/feedback-revision/{type}','Crm\Leads\LeadsController@feedbackRevisionLeads')->name('feedback_revision_leads');
    Route::get('/feedback-waiting/{type}','Crm\Leads\LeadsController@feedbackWaitingLeads')->name('feedback_waiting_leads');
    Route::get('/approved/{type}','Crm\Leads\LeadsController@approvedLeads')->name('approved_leads');
    Route::get('/final-files/{type}','Crm\Leads\LeadsController@finalFilesLeads')->name('final_files_leads');
    
});

Route::group(['prefix' => '/orders'],function(){
    Route::get('/content-order','Crm\Leads\LeadsController@contentOrderLead')->name('content-order-lead');
    Route::post('/content-order-delete','Crm\Leads\LeadsController@deleteContentOrder')->name('content-order-lead-delete');
    Route::get('/design-order','Crm\Leads\LeadsController@designOrderLead')->name('design-order-lead');
    Route::post('/design-order-delete','Crm\Leads\LeadsController@deleteDesignOrder')->name('design-order-lead-delete');
});

Route::group(['prefix' => '/brand'],function(){
    Route::get('/list','Crm\Brands\BrandsController@index')->name('brands');
    Route::post('/add','Crm\Brands\BrandsController@addbrand')->name('add_brands');
    Route::post('/update','Crm\Brands\BrandsController@updatebrand')->name('update_brands');
    Route::post('/delete','Crm\Brands\BrandsController@deletebrand')->name('delete_brands');
});

// Route::group(['prefix' => '/agent'],function(){
//     Route::get('/','Crm\Users\UsersController@index')->name('agents');
//     Route::post('/add','Crm\Users\UsersController@addagent')->name('add_agents');
//     Route::post('/update','Crm\Users\UsersController@updateagent')->name('update_agents');
//     Route::post('/delete','Crm\Users\UsersController@deleteagent')->name('delete_agents');
//     Route::get('/active_user/{id}','Crm\Users\UsersController@activateAgent')->name('active_user');
//     Route::get('/hard_delete/{id}', 'Crm\Users\UsersController@harddeleteagent')->name('hard_delete_agents');
// });

// Route::group(['prefix' => '/department'],function(){
//     Route::get('/','Crm\Department\DepartmentController@index')->name('department');
//     Route::post('/add-department','Crm\Department\DepartmentController@add')->name('add-department');
//     Route::post('/add-sub-department','Crm\Department\DepartmentController@subDepartmentAdd')->name('add-sub-department');
//     Route::post('/edit-department','Crm\Department\DepartmentController@edit')->name('edit-department');
//     Route::post('/edit-sub-department','Crm\Department\DepartmentController@editSubDepartment')->name('edit-sub-department');
// });

Route::group(['prefix' => '/profile'],function(){
    Route::get('/','Auth\AccountController@profile')->name('user-profile');
    Route::post('/profile-update','Auth\AccountController@profileUpdate')->name('user-profile-update');
    
    // Account redirection
    Route::get('/redirect/{id}','Auth\AccountController@accountRedirect')->name('account-redirection');
});

Route::group(['prefix' => '/payment'], function(){
    Route::get('/generator','Crm\Payment\PaymentController@index')->name('payment-generator');
    Route::get('/card-generator','Crm\Payment\PaymentController@cardDetialGenerator')->name('card-payment-generator');
    Route::get('/paypal-generator','Crm\Payment\PaymentController@paypalGenerator')->name('paypal-generator');
    Route::get('/out-source','Crm\Payment\PaymentController@paymentLinkOutSource')->name('payment-generator-out-source');
    Route::get('/content/out-source','Crm\Payment\PaymentController@paymentLinkOutSourceContent')->name('payment-generator-out-source-content');
    
});


// Route::group(['prefix' => '/blogs'], function(){
//     Route::get('/','Crm\Blogs\BlogsController@index')->name('blogs');
//     Route::post('/blog-post', 'Crm\Blogs\BlogsController@blogPost')->name('blog_post');
// 	Route::post('/edit-blog', 'Crm\Blogs\BlogsController@blogEditPost')->name('edit_blog_post');
// 	Route::post('/delete-blog', 'Crm\Blogs\BlogsController@blogDelete')->name('delete_blog_post');
// });




